<?php
// Securely serve PDF in-browser, disable download/copy
include 'db/db.php';
if (!isset($_GET['id'])) { die('No publication specified.'); }
$id = intval($_GET['id']);
$stmt = $conn->prepare("SELECT name, pdf_path FROM tbl_publications WHERE id=?");
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$pub = $res->fetch_assoc();
if (!$pub || !file_exists($pub['pdf_path'])) { die('Publication not found.'); }
$name = htmlspecialchars($pub['name']);
$pdf = $pub['pdf_path'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?= $name ?> - View Publication</title>
  <style>
    body { margin:0; background:#222; }
    .pdf-container { width:100vw; height:100vh; }
    .no-select, .no-select * { user-select: none !important; -webkit-user-select: none !important; }
    .pdf-toolbar { background:#222; color:#fff; padding:10px; text-align:center; }
    .pdf-toolbar button { display:none; }
  </style>
  <script>
    document.addEventListener('contextmenu', e => e.preventDefault());
    document.addEventListener('keydown', function(e) {
      // Block Ctrl+S, Ctrl+P, Ctrl+C, Ctrl+U, F12, PrintScreen
      if ((e.ctrlKey && ['s','p','c','u'].includes(e.key.toLowerCase())) || e.key === 'F12' || e.key === 'PrintScreen') {
        e.preventDefault();
        return false;
      }
    });
  </script>
</head>
<body class="no-select">
  <div class="pdf-toolbar">
    <b><?= $name ?></b> &mdash; Viewing only. Download is disabled.
  </div>
  <div class="pdf-container">
    <iframe src="<?= htmlspecialchars($pdf) ?>#toolbar=0&navpanes=0&scrollbar=0" width="100%" height="100%" style="border:none;" allowfullscreen></iframe>
  </div>
</body>
</html>
