<?php
require 'db/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $fullname = $_POST['fullname'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $phone = $_POST['phone'];
    $role = $_POST['role'];

    // Generate unique 6-digit access code
    do {
        $access_code = str_pad(strval(rand(0, 999999)), 6, '0', STR_PAD_LEFT);
        $check_sql = "SELECT user_id FROM tbl_users WHERE access_code = ?";
        $check_stmt = mysqli_prepare($conn, $check_sql);
        mysqli_stmt_bind_param($check_stmt, 's', $access_code);
        mysqli_stmt_execute($check_stmt);
        mysqli_stmt_store_result($check_stmt);
        $is_unique = mysqli_stmt_num_rows($check_stmt) === 0;
        mysqli_stmt_close($check_stmt);
    } while (!$is_unique);

    $sql = "INSERT INTO tbl_users(fullname, phone, email, password, role, access_code)
            VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'ssssss', $fullname, $phone, $email, $password, $role, $access_code);
    mysqli_stmt_execute($stmt);

    header("Location: login.php");
    //  echo "<div class='alert alert-success'>Registered successfully. Awaiting admin approval.</div>";
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="css/layout.css">
    <link rel="stylesheet" href="css/style.css">

    <title>Sign Up</title>
</head>
<body>
    <div class="main_container" >
     
      <img src="images/members.jpg" alt="" id="bg">

        <form  method="post">

           <div class="form_container" id="sign_up_form_container">

        <div class="grid-item1 logo-section">
             <div>
                <img src="images/logo.png" alt="EYN Gopel Team" title="EYN Gopel Team">
                <h3>EYN Membership Sign-up</h3>
             </div>
             <hr>
        </div>

 
        <div class="grid-item2">
                
                <div>

                        <label for="fullname">Fullname</label>
                        <input type="text" name="fullname" id="" required>
                </div>
               

              <div>
              <label for="phone_no">Phone No</label>
              <input type="text" name="phone" id="" required>
              </div>
          
               <div>
              <input type="hidden" name="role" value="Member" id="">
              </div>
        <div>
           <label for="email">Email (Optional)</label>
           <input type="email" name="email" id="">
          </div>

                
    </div>
         
    <div class="grid-item3 ">
         
         
          <div>
                <label for="password">Create Password</label>
                <input type="password" name="password" id="" required>
          </div>
          <div>
                <label for="confirm_password">Confirm Password</label>
                <input type="password" name="confirm_password" id="" required><br>
          </div>
    
</div>
 
        <div class="grid-item4 lastGridItem">
          
                <div>
                    <input type="submit" name="submit" value="Sign-up" class="my_btn" id="signUpBtn"> <br> 
                   Already have an account? <a href="login.php" class="my_btn" id="linkBtn">Login here</a>
                </div>
        </div>
        
    </div>

      </form>
     
    </div>
</body>
<script src="js/psw_validation.js"></script>
</html>