<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dob = $_POST['dob'];
    $marital_status = $_POST['marital_status'];
    $state = $_POST['state_of_origin'];
    $lga = $_POST['lga'];
    $phone = $_POST['phone'];
    $contact_address = $_POST['contact_address'];
    $permanent_address = $_POST['permanent_address'];
    $occupation = $_POST['occupation'];
    $education = $_POST['education'];
    $skill = $_POST['skill'];
    $other_skill = $_POST['other_skill'];

    $sql = "INSERT INTO users (dob, marital_status,
            state_of_origin, lga, phone, contact_address, permanent_address, occupation, education, skill, other_skill)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'sssssssssss', $dob, $marital_status, $state, $lga, $phone, $contact_address, $permanent_address, $occupation,
        $education, $skill, $other_skill);
    mysqli_stmt_execute($stmt);

    echo "<div class='alert alert-success'>Registered successfully. Awaiting admin approval.</div>";
}
?>
<?php include 'include/layout.php';  ?>
<div class="container">
  <h2>Member Registration</h2>
  <form method="post" enctype="multipart/form-data">   
    <!-- Personal Information Section -->
    <h3>Personal Information</h3>
    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Date of Birth</label>
        <input type="date" name="dob" class="form-control">
      </div>
      <div class="col-md-4">
        <label class="form-label">Marital Status</label>
        <select name="marital_status" class="form-select">
          <option>Single</option>
          <option>Married</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Profile Picture</label>
        <input type="file" name="profile_pic" class="form-control" accept="image/*">
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">State of Origin</label>
        <input name="state_of_origin" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">LGA</label>
        <input name="lga" class="form-control">
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Phone</label>
        <input name="phone" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Contact Address</label>
        <textarea name="contact_address" class="form-control" rows="2"></textarea>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-12">
        <label class="form-label">Permanent Home Address</label>
        <textarea name="permanent_address" class="form-control" rows="2"></textarea>
      </div>
    </div>

    <!-- Occupation/Skills Section -->
    <h3>Occupation / Skills</h3>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Occupation</label>
        <select name="occupation" class="form-select">
          <option>Private</option>
          <option>Self-employed</option>
          <option>Civil Servant</option>
          <option>Student</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Educational Qualification</label>
        <select name="education" class="form-select">
          <option>SSCE</option>
          <option>OND</option>
          <option>HND</option>
          <option>B.Sc</option>
          <option>Masters</option>
          <option>PhD</option>
        </select>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Professional Skills</label>
        <select name="skill" class="form-select">
          <option>Tiller</option>
          <option>Tailor</option>
          <option>Mechanic</option>
          <option>Carpenter</option>
          <option>Electrician</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Other Professional Skills</label>
        <input name="other_skill" class="form-control">
      </div>
    </div>
    
    <button type="submit" class="btn btn-primary">Register</button>
  </form>
</div>

</body>
</html>
