<?php
include 'include/layout.php';
include 'db/db.php';

// Fetch all publications
date_default_timezone_set('Africa/Lagos');
$pubs = $conn->query("SELECT * FROM tbl_publications ORDER BY created_at DESC");
?>
<div class="container">
  <h2>Publications</h2>
  <div class="row">
    <?php while($pub = $pubs->fetch_assoc()): ?>
      <div class="col-md-6 mb-4">
        <div class="card">
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($pub['name']) ?></h5>
            <p class="card-text"><?= nl2br(htmlspecialchars($pub['description'])) ?></p>
            <a href="view_publication.php?id=<?= $pub['id'] ?>" class="btn btn-primary" target="_blank">View PDF</a>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>
<?php include 'include/footer.php'; ?>
