<?php include 'include/layout.php'; 
include 'db/db.php'; 

if (!isset($_SESSION)) {
    session_start();
}

/*
if(isset($_SESSION['bio_filled_out']) && $_SESSION['bio_filled_out'] == "1") {
  echo "<div class='alert alert-success' id='alert-bio'>You have already filled out your membership bio.</div>";
  unset($_SESSION['bio_filled_out']);
}
*/

if(isset($_SESSION['profile_updated']) && $_SESSION['profile_updated'] == "1") {
  echo "<div class='alert alert-success' id='alert-profile'>Profile updated successfully.</div>";
  unset($_SESSION['profile_updated']);      
}

// Fetch user data from the database
  $userId = $_SESSION['user']['user_id']; // Assuming user ID is stored in session
  $query = "SELECT u.fullname, u.email, u.phone, m.profile_picture, m.* FROM tbl_users u INNER JOIN tbl_members_info m ON u.user_id = m.user_id WHERE u.user_id = ?";
  $stmt = $conn->prepare($query);
  $stmt->bind_param("i", $userId);
  $stmt->execute();
  $result = $stmt->get_result();
  $user = $result->fetch_assoc();
  if (!$user) {

   echo '<div class="alert alert-danger">User not found.</div>';

      exit;
  }
  ?>
<div class="container">
  
    <div class="profile-header">
      <div class="profile-pic">
         <img src="<?= $user['profile_picture'] ? htmlspecialchars($user['profile_picture']) : 'images/user_icon.png' ?>" alt="Profile Picture" class="profile-logo">
      
      </div>
      <div class="profile-name">
        <h2><?= htmlspecialchars($user['fullname'] ?? 'fullname') ?> </h2> <hr>
     <label style="color:black"><b>Registration:</b> </label>   <span class=" badge status-<?= $user['status'] ?>"> <?= htmlspecialchars($user['status'] ?? 'status') ?></span>
      <div style="color:black" class="pt-4"><label ><b>Position:</b> </label><span> <?= htmlspecialchars($user['rank'] ?? 'rank') ?></span></div>
      </div>
      <button class="btn btn-primary edit-btn" onclick="window.location.href='edit_profile.php'">
        <i class="fa-solid fa-pen"></i> Edit Profile
      </button>
    </div>
    <hr>
    <div class="profile-section sign_up_info">
      <h4><i class="fa-solid fa-id-card"></i> Sign Up Info</h4>
      <div class="row mb-3">
        <div class="col-md-6"><strong>Email:</strong> <?= htmlspecialchars($user['email'] ?? '') ?></div>
        <div class="col-md-6"><strong>Phone:</strong> <?= htmlspecialchars($user['phone'] ?? '') ?></div>
        <div class="col-md-6"><strong>Gender:</strong> <?= htmlspecialchars($user['gender'] ?? '') ?></div>
        <div class="col-md-6"><strong>Online Account Since:</strong> <?= htmlspecialchars($user['created_at'] ?? '') ?></div>
      </div>
    </div>
    <div class="profile-section personal_info">
      <h4><i class="fa-solid fa-user"></i> Personal Information</h4>
      <div class="row mb-3">
        <div class="col-md-4"><strong>Date of Birth:</strong> <?= htmlspecialchars($user['dob'] ?? '') ?></div>
        <div class="col-md-4"><strong>Marital Status:</strong> <?= htmlspecialchars($user['marital_status'] ?? '') ?></div>
        <div class="col-md-4"><strong>Phone:</strong> <?= htmlspecialchars($user['phone'] ?? '') ?></div>
      </div>
      <div class="row mb-3">
        <div class="col-md-4"><strong>State of Origin:</strong> <?= htmlspecialchars($user['state_of_origin'] ?? '') ?></div>
        <div class="col-md-4"><strong>LGA:</strong> <?= htmlspecialchars($user['lga'] ?? '') ?></div>
     </div>
      <div class="row mb-3">
        <div class="col-md-4"><strong>EYN LCC:</strong> <?= htmlspecialchars($user['eyn_lcc'] ?? '') ?></div>
        <div class="col-md-4"><strong>EYN DCC:</strong> <?= htmlspecialchars($user['eyn_dcc'] ?? '') ?></div>
      </div>
      <div class="row mb-3">
        <div class="col-md-12"><strong>Permanent Home Address:</strong> <?= htmlspecialchars($user['permanent_address'] ?? '') ?></div>
      </div>
    </div>
    <div class="profile-section occupation_skills">
      <h4><i class="fa-solid fa-briefcase"></i> Occupation / Skills</h4>
      <div class="row mb-3">
        <div class="col-md-6"><strong>Occupation:</strong> <?= htmlspecialchars($user['occupation'] ?? '') ?></div>
        <div class="col-md-6"><strong>Education:</strong> <?= htmlspecialchars($user['education'] ?? '') ?></div>
      </div>
      <div class="row mb-3">
          <div class="col-md-6"><strong>Professional Skill:</strong> <?= htmlspecialchars($user['skill'] ?? '') ?></div>
      
        <div class="col-md-6"><strong>Other Skills:</strong> <?= htmlspecialchars($user['other_skill'] ?? '') ?></div>
      </div>
  </div>
</div>

   <?php include 'include/footer.php'; ?>
   <script src="js/admin_main.js"></script>

  