<?php
// password-reset.php
require 'db/db.php';
if (!isset($_SESSION)) {
    session_start();
}
// Check if session variables for password reset are set

if (!isset($_SESSION['reset_phone']) || !isset($_SESSION['reset_access_code'])) {
    header('Location: forgot_password.php');
    exit();
}

$phone = $_SESSION['reset_phone'];
$access_code = $_SESSION['reset_access_code'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    if ($new_password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $sql = "UPDATE tbl_users SET password = ? WHERE phone = ? AND access_code = ?";
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, 'sss', $hashed_password, $phone, $access_code);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        // Clear session
        unset($_SESSION['reset_phone']);
        unset($_SESSION['reset_access_code']);
        $success = "Password reset successful. You can now <a href='login.php'>login</a>.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/layout.css">
    <link rel="stylesheet" href="css/style.css">
    <title>Reset Password</title>
</head>
<body>
    <div class="main_container">
        <form method="post" class="form_container" style="max-width:400px;margin:0px auto;">
            <div class="grid-item1 logo-section">
                <img src="images/logo.png" alt="Logo" class="login-logo">
                <h3>Reset Password</h3>
            </div>
            <?php if (!empty($error)) { echo "<p class='errmsg'>$error</p>"; } ?>
            <?php if (!empty($success)) { echo "<p class='errmsg' style='color:green;'>$success</p>"; } ?>
        <div>
            <div class="input-group">
                <label for="new_password">New Password</label>
                <input type="password" name="new_password" id="new_password" class="input-field" required>
            </div>
            <div class="input-group">
                <label for="confirm_password">Confirm New Password</label>
                <input type="password" name="confirm_password" id="confirm_password" class="input-field" required>
            </div>
        </div>
        <div>
            <div class="button-group">
                <input type="submit" value="Reset Password" class="my_btn login-btn">
            </div>
            <div class="signup-group">
                <a href="login.php" class="my_btn signup-link">Back to Login</a>
            </div>
         </div>   
        </form>
    </div>
</body>
</html>
