<?php include 'include/layout.php'; 
      require 'db/db.php';
require_login();
// Check if user has already filled out the bio

$check = $conn->prepare("SELECT tbl_users.user_id FROM tbl_users
    INNER JOIN tbl_members_info ON tbl_users.user_id = tbl_members_info.user_id
    WHERE tbl_users.user_id = ?");

    $check->bind_param("i", $user_id);
    $check->execute();
    $result = $check->get_result();

if ($result->num_rows > 0) {
    // User has already filled out the bio
      $_SESSION['bio_filled_out'] = "1";
    // Redirect to profile or dashboard
    header("Location: profile.php");
    exit();
}

// Show bio form
// Continue with bio form display
?>

<?php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_SESSION['user']['user_id'];
    $dob = $_POST['dob'];
    $gender = $_POST['gender'];
    $marital_status = $_POST['marital_status'];
    $state = $_POST['state_of_origin'];
    $lga = $_POST['lga'];
    $eyn_lcc = $_POST['eyn_lcc'];
    $eyn_dcc = $_POST['eyn_dcc'];
    $permanent_address = $_POST['permanent_address'];
    $occupation = $_POST['occupation'];
    $education = $_POST['education'];
    $skill = $_POST['skill'];
    $other_skill = $_POST['other_skill'];

    // Handle profile picture upload
    $profile_picture = '';
    if (isset($_FILES['profile_pic']) && $_FILES['profile_pic']['error'] == UPLOAD_ERR_OK) {
        $target_dir = "images/profile_pics/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_name = uniqid() . '_' . basename($_FILES['profile_pic']['name']);
        $target_file = $target_dir . $file_name;
        if (move_uploaded_file($_FILES['profile_pic']['tmp_name'], $target_file)) {
            $profile_picture = $target_file;
        }
    }

    $sql = "INSERT INTO tbl_members_info (user_id, dob, gender, marital_status,
            state_of_origin, lga, eyn_lcc, eyn_dcc, permanent_address,
             occupation, education, skill, other_skill, profile_picture)
            VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'isssssssssssss', $id, $dob, $gender, $marital_status,
     $state, $lga,  $eyn_lcc, $eyn_dcc, $permanent_address, $occupation,
        $education, $skill, $other_skill, $profile_picture);
    mysqli_stmt_execute($stmt);

    echo "<div class='alert alert-success' id='alert-profile'>Registered successfully. Awaiting admin approval.</div>";
}
?>

<div class="container">
  <h2>Membership Registration</h2>
  <p>Please fill out the form below to complete your membership registration</p>
  <h3>Personal Information</h3>

  <form method="post" enctype="multipart/form-data" class="d-inline">
 
  <!-- Personal Information Section -->

<div class="row  mb-3">
      <div class="col-md-4 mb-2 mb-md-0">
        <label class="form-label"><i class="fa-solid fa-calendar-days"></i> Date of Birth</label>
        <input type="date" name="dob" class="form-control">
      </div>
      <div class="col-md-4 mb-2 mb-md-0">
        <div class="form-label"><i class="fa-solid fa-venus-mars"></i> Gender</div>
        <select name="gender" class="form-select">
          <option value="Male">Male</option>
          <option value="Female">Female</option>
        </select>
      </div>
        <div class="col-md-4 mb-2 mb-md-0">
          <label class="form-label"><i class="fa-solid fa-heart"></i> Marital Status</label>
          <select name="marital_status" class="form-select">
            <option value="Single">Single</option>
            <option value="Married">Married</option>
            <option value="Divorced">Divorced</option>
          </select>
        </div>
      
</div>
<div class="row mb-3">
      <div class="col-md-6 mb-2 mb-md-0">
        <label class="form-label"><i class="fa-solid fa-location-dot"></i> State of Origin</label>
        <input name="state_of_origin" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label"><i class="fa-solid fa-map"></i> LGA</label>
        <input name="lga" class="form-control">
      </div>
</div>
<div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label"><i class="fa-solid fa-church"></i> Contact Address EYN LCC</label>
        <input name="eyn_lcc" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label"><i class="fa-solid fa-church"></i> EYN DCC</label>
        <input name="eyn_dcc" class="form-control">
      </div>
</div>

<div class="row mb-3">
    <div class="col-md-12">
      <label class="form-label"><i class="fa-solid fa-house"></i> Permanent Home Address</label>
      <textarea name="permanent_address" class="form-control" rows="2"></textarea>
    </div>
</div>

<h3>Occupation / Skills</h3>
  <div class="row mb-3">
    <div class="col-md-6">
      <label class="form-label"><i class="fa-solid fa-briefcase"></i> Occupation</label>
      <select name="occupation" class="form-select">
        <option value="Private">Private</option>
        <option value="Self-employed">Self-employed</option>
        <option value="Civil Servant">Civil Servant</option>
        <option value="Applicant">Applicant</option>
        <option value="Student">Student</option>
        <option value="Other">Other</option>
      </select>
    </div>
    <div class="col-md-6">
      <label class="form-label"><i class="fa-solid fa-graduation-cap"></i> Educational Qualification</label>
      <select name="education" class="form-select">
        <option value="SSCE">SSCE</option>
        <option value="OND">OND</option>
        <option value="HND">HND</option>
        <option value="PGD">PGD</option>
        <option value="B.Sc">B.Sc</option>
        <option value="Masters">Masters</option>
        <option value="PhD">PhD</option>
        <option value="Other">Other</option>
      </select>
    </div>
  </div>

<div class="row mb-3">
  <div class="col-md-6">
    <label class="form-label"><i class="fa-solid fa-tools"></i> Professional Skills (handwork)</label>
    <select name="skill" class="form-select">
      <option value="Tiller">Tiller</option>
      <option value="Mason">Mason</option>
      <option value="Tailor">Tailor</option>
      <option value="Painter">Painter</option>
      <option value="Mechanic">Mechanic</option>
      <option value="Carpenter">Carpenter</option>
      <option value="Electrician">Electrician</option>
      <option value="Plumber">Plumber</option>
      <option value="Other">Other</option>
    </select>
  </div>
    <div class="col-md-6">
      <label class="form-label"><i class="fa-solid fa-plus"></i> Other Professional Skills</label>
      <input name="other_skill" class="form-control">
    </div>
    <div class="col-md-4 mb-2 mb-md-0">
        <label class="form-label"><i class="fa-solid fa-image"></i> Profile Picture</label>
        <input type="file" name="profile_pic" class="form-control" accept="image/*">
      </div>
</div>

 <input type="submit" class="btn btn-primary" value="Register" name="register">
   </form>
      
  </div>


   <?php include 'include/footer.php'; ?>
<script src="js/admin_main.js"></script>
