
<?php
include 'include/layout.php';
include 'db/db.php';
require_login();
// Handle upload
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['pdf'])) {
    $name = trim($_POST['name']);
    $desc = trim($_POST['description']);
    $file = $_FILES['pdf'];
    if ($file['type'] === 'application/pdf' && $file['size'] < 10*1024*1024) {
        $target = 'publications/' . time() . '_' . basename($file['name']);
        if (move_uploaded_file($file['tmp_name'], $target)) {
            $stmt = $conn->prepare("INSERT INTO tbl_publications (name, description, pdf_path, created_at) VALUES (?, ?, ?, NOW())");
            $stmt->bind_param('sss', $name, $desc, $target);
            $stmt->execute();
            $msg = '<div class="alert alert-success">Publication added!</div>';
        } else {
            $msg = '<div class="alert alert-danger">Upload failed.</div>';
        }
    } else {
        $msg = '<div class="alert alert-danger">Invalid PDF or file too large.</div>';
    }
}
// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $res = $conn->query("SELECT pdf_path FROM publications WHERE id=$id");
    if ($row = $res->fetch_assoc()) {
        @unlink($row['pdf_path']);
        $conn->query("DELETE FROM publications WHERE id=$id");
        $msg = '<div class="alert alert-success">Publication deleted.</div>';
    }
}
$pubs = $conn->query("SELECT * FROM tbl_publications ORDER BY created_at DESC");
?>
<div class="container">
  <h2>Manage Publications</h2>
  <?= $msg ?>
  <form method="post" enctype="multipart/form-data" class="mb-4">
    <div class="mb-2">
      <label>Name</label>
      <input type="text" name="name" class="form-control" required>
    </div>
    <div class="mb-2">
      <label>Description</label>
      <textarea name="description" class="form-control" required></textarea>
    </div>
    <div class="mb-2">
      <label>PDF File</label>
      <input type="file" name="pdf" accept="application/pdf" class="form-control" required>
    </div>
    <button type="submit" class="btn btn-success">Add Publication</button>
  </form>

  <h4>All Publications</h4>
  <div class="table-responsive">
       <table class="table table-bordered table-striped member-table">
    <thead><tr><th>#</th><th>Name</th><th>Description</th><th>PDF</th><th>Action</th></tr></thead>
    <tbody>
      <?php $serial = 1; while($pub = $pubs->fetch_assoc()): ?>
        <tr>
          <td><?= $serial++ ?></td>
          <td><?= htmlspecialchars($pub['name']) ?></td>
          <td><?= nl2br(htmlspecialchars($pub['description'])) ?></td>
          <td><a href="view_publication.php?id=<?= $pub['id'] ?>" target="_blank">View</a></td>
          <td><a href="?delete=<?= $pub['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this publication?')">Delete</a></td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</div>
<?php include 'include/footer.php'; ?>
