<?php

include 'include/layout.php';
require 'db/db.php';

if (!isset($_SESSION)) {
    session_start();
}
require_login();

// Handle status update (approval, pending, canceled)
if (isset($_POST['member_info_id'], $_POST['status'])) {
    $id = intval($_POST['member_info_id']);
    $status = $_POST['status'];
    $stmt = $conn->prepare("UPDATE tbl_members_info SET status=? WHERE member_info_id=?");
    $stmt->bind_param('si', $status, $id);
    $stmt->execute();
}

// Handle rank update
if (isset($_POST['member_info_id'], $_POST['rank'])) {
    $id = intval($_POST['member_info_id']);
    $rank = $_POST['rank'];
    $stmt = $conn->prepare("UPDATE tbl_members_info SET `rank`=? WHERE member_info_id=?");
    $stmt->bind_param('si', $rank, $id);
    $stmt->execute();
}

// Filters
$filter_status = $_GET['status'] ?? '';
$filter_search = $_GET['search'] ?? '';

// Build query

$query = "SELECT m.*, u.fullname, u.phone, u.email, m.profile_picture FROM tbl_members_info m INNER JOIN tbl_users u ON m.user_id = u.user_id WHERE 1";
$params = [];

if ($filter_status) {
    $query .= " AND m.status = ?";
    $params[] = $filter_status;
}
if ($filter_search) {
    $query .= " AND (u.fullname LIKE ? OR u.phone LIKE ? OR u.email LIKE ?)";
    $search = "%$filter_search%";
    $params = array_merge($params, [$search, $search, $search]);
}

$query .= " ORDER BY m.created_at DESC";
$stmt = $conn->prepare($query);
if ($params) {
    // Dynamically build types string
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$members = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];
?>

<div class="container">
  <h2>Manage Members</h2>
  <form method="get" class="filter-form mb-3" id="filterForm">
    <div class="row g-2 align-items-end">
      <div class="col-12 col-md-3 mb-2 mb-md-0">
        <label for="status" class="form-label d-md-none">Status</label>
        <select id="status" name="status" class="form-select">
          <option value="">All Status</option>
          <option value="Pending" <?= $filter_status=='Pending'?'selected':'' ?>>Pending</option>
          <option value="Approved" <?= $filter_status=='Approved'?'selected':'' ?>>Approved</option>
          <option value="Canceled" <?= $filter_status=='Canceled'?'selected':'' ?>>Canceled</option>
        </select>
      </div>
      <div class="col-12 col-md-5 mb-2 mb-md-0">
        <label for="search" class="form-label d-md-none">Search</label>
        <input id="search" type="text" name="search" class="form-control" placeholder="Search name, phone, email..." value="<?= htmlspecialchars($filter_search) ?>">
      </div>
      <div class="col-6 col-md-2 mb-2 mb-md-0 d-grid">
        <button type="submit" class="btn btn-primary w-100 d-inline-flex align-items-center fw-normal px-4 py-2"><i class="fa fa-filter"></i> Filter</button>
      </div>
      <div class="col-6 col-md-2 d-grid">
        <a href="manage_members.php" class="btn btn-secondary w-100 fw-normal px-4 py-2">Reset</a>
      </div>
      <div class="col-12 col-md-2 d-grid mt-3 mt-md-0">
       <a href="export_members_pdf.php" class="btn btn-info w-100 mt-3 d-inline-flex align-items-center">
  <i class="fa fa-file-pdf me-2"></i><span> Download</span> </a>

      </div>
    </div>
  </form>
  
    <div class="table-responsive">
       <table class="table table-bordered table-striped member-table">
      <thead>
        <tr>
          <th>#</th>
          <th>Action</th>
          <th>Profile</th>
          <th>Name</th>
           <th>Phone</th>
          <th>Email</th>
         
          <th>Status</th>
           <th>Rank</th>    
          <th>DOB</th>
          <th>Gender</th>
          <th>Marital Status</th>
          <th>State</th>
          <th>LGA</th>
          <th>Permanent Address</th>
          <th>EYN LCC</th>
          <th>EYN DCC</th>
          <th>Occupation</th>
          <th>Education</th>
          <th>Skills</th>
          <th>Other Skills</th>
          <th>Registered</th>
        </tr>
      </thead>
      <tbody>
      
        <?php $serial = 1; foreach ($members as $member): ?>
        <tr>
          <td><?= $serial++ ?></td>
          <td>
            <div class="action-inline-forms">
              <form method="post" class="d-inline action-form" style="margin-right: 6px;">
                <input type="hidden" name="member_info_id" value="<?= $member['member_info_id'] ?>">
                <?php
                  $status_options = [
                    'pending' => 'Pending',
                    'approved' => 'Approved',
                    'canceled' => 'Canceled'
                  ];
                ?>
                <select name="status" class="form-select form-select-sm" style="display:inline-block; width:auto; min-width:120px;" onchange="this.form.submit()">
                  <option value="" disabled selected>Change Status</option>
                  <?php foreach($status_options as $value => $label): ?>
                    <?php if(strtolower($member['status']) != strtolower($value)): ?>
                      <option value="<?= $value ?>"><?= $label ?></option>
                    <?php endif; ?>
                  <?php endforeach; ?>
                </select>
              </form>
              <form method="post" class="d-inline action-form" style="margin-right: 6px;">
                <input type="hidden" name="member_info_id" value="<?= $member['member_info_id'] ?>">
                <?php
                  $rank_options = [
                    'National Chairman' => 'National Chairman',
                    'Vice Chairman' => 'Vice Chairman',
                    'National Secretary' => 'National Secretary',
                    'Assistant National Secretary' => 'Assistant National Secretary',
                    'Financial Secretary' => 'Financial Secretary',
                    'Treasurer' => 'Treasurer',
                    'Bible Study Secretary' => 'Bible Study Secretary',
                    'Song Leader' => 'Song Leader',
                    'Outreach Secretary' => 'Outreach Secretary',
                    'Welfare' => 'Welfare',
                    'Youth Leader' => 'Youth Leader',
                    'PRO' => 'PRO',
                    'Member' => 'Member',
                    'Other' => 'Other'
                  ];
                  $current_rank = isset($member['rank']) ? $member['rank'] : '';
                ?>
                <select name="rank" class="form-select form-select-sm" style="display:inline-block; width:auto; min-width:120px;" onchange="this.form.submit()">
                  <option value="" disabled selected>Change Rank</option>
                  <?php foreach($rank_options as $value => $label): ?>
                    <?php if($current_rank != $value): ?>
                      <option value="<?= $value ?>"><?= $label ?></option>
                    <?php endif; ?>
                  <?php endforeach; ?>
                </select>
              </form>
            </div>
          </td>
          <td>
            <img src="<?= $member['profile_picture'] ? htmlspecialchars($member['profile_picture']) : 'images/user_icon.png' ?>" alt="Profile" class="table-profile-pic">
          </td>
          <td><?= htmlspecialchars($member['fullname']) ?></td>
          <td><?= htmlspecialchars($member['phone']) ?></td>
          <td><?= htmlspecialchars($member['email']) ?></td>
          <td>
            <span class="badge status-<?= strtolower($member['status']) ?>">
              <?= htmlspecialchars($member['status']) ?>
            </span>
          </td>
          <td>
            <span class=" status-<?= strtolower($member['rank']) ?>">
              <?= htmlspecialchars($member['rank']) ?>
            </span>
          </td>
          <td><?= htmlspecialchars($member['dob']) ?></td>
          <td><?= htmlspecialchars($member['gender']) ?></td>
          <td><?= htmlspecialchars($member['marital_status']) ?></td>
          <td><?= htmlspecialchars($member['state_of_origin']) ?></td>
          <td><?= htmlspecialchars($member['lga']) ?></td>
          <td><?= htmlspecialchars($member['permanent_address']) ?></td>
          <td><?= htmlspecialchars($member['eyn_lcc']) ?></td>
          <td><?= htmlspecialchars($member['eyn_dcc']) ?></td>
          <td><?= htmlspecialchars($member['occupation']) ?></td>
          <td><?= htmlspecialchars($member['education']) ?></td>
          <td><?= htmlspecialchars($member['skill']) ?></td>
          <td><?= htmlspecialchars($member['other_skill']) ?></td>
          <td><?= htmlspecialchars($member['created_at']) ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

</div>

   <?php include 'include/footer.php'; ?>