<?php
include 'include/layout.php';
include 'db/db.php';

// Get current year
$year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');

// Handle status update
if (isset($_POST['member_id'], $_POST['status'], $_POST['year'])) {
    $member_id = intval($_POST['member_id']);
    $status = $_POST['status'] === 'Paid' ? 'Paid' : 'Not-Paid';
    $year_post = intval($_POST['year']);
    // Check if record exists
    $stmt = $conn->prepare("SELECT id FROM tbl_membership_dues WHERE member_info_id=? AND year=?");
    $stmt->bind_param('ii', $member_id, $year_post);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows > 0) {
        $stmt2 = $conn->prepare("UPDATE tbl_membership_dues SET status=?, payment_date=IF(?='Paid', NOW(), NULL) WHERE member_info_id=? AND year=?");
        $stmt2->bind_param('ssii', $status, $status, $member_id, $year_post);
        $stmt2->execute();
    } else {
        $stmt2 = $conn->prepare("INSERT INTO tbl_membership_dues (member_info_id, year, status, payment_date) VALUES (?, ?, ?, IF(?='Paid', NOW(), NULL))");
        $stmt2->bind_param('iiss', $member_id, $year_post, $status, $status);
        $stmt2->execute();
    }
}

// Get all members
$members = $conn->query("SELECT m.member_info_id, u.fullname, u.phone, u.email FROM tbl_members_info m INNER JOIN tbl_users u ON m.user_id = u.user_id ORDER BY u.fullname");

// Get dues for all members for the selected year
$dues = [];
$res = $conn->prepare("SELECT member_info_id, status FROM tbl_membership_dues WHERE year = ?");
$res->bind_param("i", $year);
$res->execute();
$result = $res->get_result();

while($row = $result->fetch_assoc()) {
    $dues[$row['member_info_id']] = $row['status'];
}

?>
<div class="container">
  <h2>Manage Membership Dues (<?= $year ?>)</h2>
  <form method="get" class="mb-3">
    <label>Select Year:</label>
    <select name="year" onchange="this.form.submit()" class="form-select d-inline w-auto px-2">
      <?php for($y = date('Y')-5; $y <= date('Y')+1; $y++): ?>
        <option value="<?= $y ?>" <?= $y==$year?'selected':'' ?>><?= $y ?></option>
      <?php endfor; ?>
    </select>
  </form>

   <div class="table-responsive">
       <table class="table table-bordered table-striped member-table">
    <thead><tr><th>#</th><th>Name</th><th>Phone</th><th>Email</th><th>Status</th><th>Action</th></tr></thead>
    <tbody>
      <?php $serial=1; while($m = $members->fetch_assoc()): $mid = $m['member_info_id']; ?>
        <tr>
          <td><?= $serial++ ?></td>
          <td><?= htmlspecialchars($m['fullname']) ?></td>
          <td><?= htmlspecialchars($m['phone']) ?></td>
          <td><?= htmlspecialchars($m['email']) ?></td>
          <td>
            <span class="badge bg-<?= (isset($dues[$mid]) && $dues[$mid]==='Paid') ? 'success' : 'danger' ?>">
              <?= isset($dues[$mid]) ? $dues[$mid] : 'Not Paid' ?>
            </span>
          </td>
          <td>
            <form method="post" class="d-inline">
              <input type="hidden" name="member_id" value="<?= $mid ?>">
              <input type="hidden" name="year" value="<?= $year ?>">
              <select name="status" class="form-select d-inline w-auto" onchange="this.form.submit()">
                <option value="Paid" <?= (isset($dues[$mid]) && $dues[$mid]==='Paid') ? 'selected' : '' ?>>Paid</option>
                <option value="Not Paid" <?= (!isset($dues[$mid]) || $dues[$mid]!=='Paid') ? 'selected' : '' ?>>Not Paid</option>
              </select>
            </form>
          </td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>  
</div>
<?php include 'include/footer.php'; ?>
