<?php  include 'include/layout.php';  ?>

  <?php  require 'db/db.php';

// Handle role update
if (isset($_POST['role'])) {
    $user_id = $_POST['user_id'];
    $new_role = $_POST['role'];
    $update_sql = "UPDATE tbl_users SET role = ? WHERE user_id = ?";
    $update_stmt = mysqli_prepare($conn, $update_sql);
    mysqli_stmt_bind_param($update_stmt, 'si', $new_role, $user_id);
    mysqli_stmt_execute($update_stmt);
    mysqli_stmt_close($update_stmt);
    header('Location: manage_admins.php');
    exit();
}

// Fetch all users
$sql = "SELECT user_id, fullname, phone, email, role , access_code FROM tbl_users ORDER BY user_id DESC";
$result = mysqli_query($conn, $sql);
if (!$result) {
    die("Database query failed: " . mysqli_error($conn));
}
// Define roles
$roles = [
    'Admin' => 'Admin',
    'Member' => 'Member'
];
?>
    <div class="container">
    <div class="main_container">
        <h2>Manage Admins & User Roles</h2>
       
     <div class="table-responsive">
       <table class="table table-bordered table-striped member-table">
      <thead>
      <tr>
                        <th>ID</th>
                        <th>Full Name</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Current Role</th>
                        <th>Change Role</th>
                        <th>Access Code</th>
                    </tr>
                </thead>
                <tbody>
                <?php while($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td><?php echo $row['user_id']; ?></td>
                        <td><?php echo htmlspecialchars($row['fullname']); ?></td>
                        <td><?php echo htmlspecialchars($row['phone']); ?></td>
                        <td><?php echo htmlspecialchars($row['email']); ?></td>
                        <td><?php echo htmlspecialchars($row['role']); ?></td>
                       <td>
                            <form method="post" class="d-inline role-change-form">
                                <input type="hidden" name="user_id" value="<?php echo $row['user_id']; ?>">
                                <select name="role" class="form-select" onchange="this.form.submit()">
                                    <option value="" disabled selected>Change Role</option>
                                    <?php foreach($roles as $val => $label): ?>
                                        <?php if($row['role'] != $val): ?>
                                            <option value="<?php echo $val; ?>"><?php echo $label; ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                            </form>
                        </td>
                        <td><?php echo htmlspecialchars($row['access_code']); ?></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
    </div>
    <?php include 'include/footer.php'; ?>
