<?php include 'include/bootstrap.php';  ?>
<?php
$current = basename($_SERVER['PHP_SELF'], ".php");

if (!isset($_SESSION)) {
    session_start();
}

require 'include/access_control.php';
?>
<?php
require 'db/db.php';
$user_id = $_SESSION['user']['user_id'];

// Check if user has a record in tbl_members_info
$stmt = $conn->prepare("SELECT user_id FROM tbl_members_info WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$has_bio = ($result->num_rows > 0);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>EYN Gospel Team Membership</title>
  <link rel="icon" href="images/logo.png" type="image/png" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="css/admin_style.css">
  <!-- Add this in your <head> -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    .menu-icon {
      margin-right: 10px;
    }
  </style>
</head>
<body>

  <div class="header d-flex justify-content-between align-items-center px-3">
      <span class="header-title"><a href="dashboard.php" class="text-decoration-none" style="color:white"><b>EYN Gospel Team Membership</b></a></span>
  
   <button class="hamburger" onclick="toggleMenu()">⋮⋮⋮</button>
  </div>

  <div class="wrapper">
  <aside class="sidebar">
       <div class="profile-logo">
    <img src="images/logo.png" alt="Logo" class="profile-logo">
  </div> 
      <ul id="nav-list">
      <?php if (is_admin()): ?>
       <li class="<?= $current === 'dashboard' ? 'active' : '' ?>"><a href="dashboard.php"><span class="menu-icon"><i class="fas fa-tachometer-alt"></i> </span>Dashboard</a></li>
        <li class="<?= $current === 'manage_members' ? 'active' : '' ?>"><a href="manage_members.php"><span class="menu-icon"><i class="fas fa-user-plus"></i> </span>Manage Members</a></li>
          <li class="<?= $current === 'manage_dues' ? 'active' : '' ?>"><a href="manage_dues.php"><span class="menu-icon"><i class="fas fa-money-bill-wave"></i> </span>Manage Dues</a></li>
      
        <li class="<?= $current === 'manage_publications' ? 'active' : '' ?>"><a href="manage_publications.php"><span class="menu-icon"><i class="fas fa-book"></i> </span>Manage Publications</a></li>
      <li class="<?= $current === 'manage_admins' ? 'active' : '' ?>"><a href="manage_admins.php"><span class="menu-icon"><i class="fas fa-users-cog"></i> </span>Manage Accounts</a></li>
        <?php if (!$has_bio): ?>
  
        <li class="<?= $current === 'membership_bio' ? 'active' : '' ?>"><a href="membership_bio.php"><span class="menu-icon bio"><i class="fas fa-user"></i> </span>Fill My bio</a></li>     
        <?php endif; ?>
        <li class="<?= $current === 'dues_status' ? 'active' : '' ?>"><a href="dues_status.php"><span class="menu-icon"><i class="fas fa-receipt"></i> </span>My Dues Status</a></li>
        <?php endif; ?>
          <?php if (is_member()): ?>
             <?php if (!$has_bio): ?> 
        <li class="<?= $current === 'membership_bio' ? 'active' : '' ?>"><a href="membership_bio.php"><span class="menu-icon bio"><i class="fas fa-user"></i> </span>Fill My bio</a></li>      
           <?php endif; ?>
        <li class="<?= $current === 'publication' ? 'active' : '' ?>"><a href="publications.php"><span class="menu-icon"><i class="fas fa-book-open"></i> </span>View Publication</a></li>
        <li class="<?= $current === 'dues_status' ? 'active' : '' ?>"><a href="dues_status.php"><span class="menu-icon"><i class="fas fa-receipt"></i> </span>My Dues Status</a></li>
         <?php endif; ?>
        <li class="<?= $current === 'profile' ? 'active' : '' ?>"><a href="profile.php"><span class="menu-icon"><i class="fas fa-user-circle"></i> </span>User Profile</a></li>
        <li><a href="logout.php"><span class="menu-icon"><i class="fas fa-sign-out-alt"></i> </span>Logout</a></li>
      </ul>

      <div class="version">
        V. 2.0
      </div>
  </aside>

    <main class="content">
