<?php
// access_control.php
// This file contains functions to control access based on user roles.
if (!isset($_SESSION)) {
    session_start();
}

function is_logged_in() {
    return isset($_SESSION['user']);
}

function is_admin() {
    return is_logged_in() && $_SESSION['user']['role'] === 'Admin';
}

function is_member() {
    return is_logged_in() && $_SESSION['user']['role'] === 'Member';
}

function require_role($role) {
    if (!is_logged_in() || $_SESSION['user']['role'] !== $role) {
        header("Location: no_access.php");
        exit();
    }
}

function require_login() {
    if (!is_logged_in()) {
        header("Location: login.php");
        exit();
    }
}