<?php
// forgot_password.php
require 'db/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = $_POST['phone'];
    $access_code = $_POST['access_code'];

    $sql = "SELECT user_id FROM tbl_users WHERE phone = ? AND access_code = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'ss', $phone, $access_code);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);

    if (mysqli_stmt_num_rows($stmt) > 0) {
        // User found, redirect to password reset page
        session_start();
        $_SESSION['reset_phone'] = $phone;
        $_SESSION['reset_access_code'] = $access_code;
        header('Location: password-reset.php');
        exit();
    } else {
        $error = "Invalid phone or access code.";
    }
    mysqli_stmt_close($stmt);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/layout.css">
    <link rel="stylesheet" href="css/style.css">
    <title>Forgot Password</title>
</head>
<body>
    <div class="main_container">
        <form method="post" class="form_container" style="max-width:400px;margin:0px auto;">
            <div class="logo-section">
                <div class="grid-item1 logo-section">
                <img src="images/logo.png" alt="Logo" class="login-logo">
                <h3>Forgot Password</h3>
            </div>
            <?php if (!empty($error)) { echo "<p class='errmsg'>$error</p>"; } ?>
            <div>
            <div class="input-group">
                <label for="phone">Phone Number</label>
                <input type="text" name="phone" id="phone" class="input-field" required>
            </div>
            <div class="input-group">
                <label for="access_code">UserID</label>
                <input type="text" name="access_code" id="access_code" class="input-field" maxlength="6" required>
            </div>
            </div>
        <div>
            <div class="button-group">
                <input type="submit" value="Verify" class="my_btn login-btn">
            </div>
          
                <a href="login.php" class="my_btn signup-link">Back to Login</a>
         
            </div>
        </form>
    </div>
</body>
</html>
