<?php
require_once __DIR__ . '/vendor/tcpdf/tcpdf.php';
require 'db/db.php';

// Get filters from POST
$filter_status = $_POST['status'] ?? '';
$filter_search = $_POST['search'] ?? '';

// Build query (same as manage_members.php)
$query = "SELECT m.*, u.fullname, u.phone, u.email FROM tbl_members_info m INNER JOIN tbl_users u ON m.user_id = u.user_id WHERE 1";
$params = [];
if ($filter_status) {
    $query .= " AND m.status = ?";
    $params[] = $filter_status;
}
if ($filter_search) {
    $query .= " AND (u.fullname LIKE ? OR u.phone LIKE ? OR u.email LIKE ?)";
    $search = "%$filter_search%";
    $params = array_merge($params, [$search, $search, $search]);
}
$query .= " ORDER BY m.created_at DESC";
$stmt = $conn->prepare($query);
if ($params) {
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$members = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

// Create PDF
$pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
$pdf->SetCreator('Membership System');
$pdf->SetAuthor('Membership System');
$pdf->SetTitle('Members List');
$pdf->SetHeaderData('', 0, 'Members List', 'Exported: '.date('Y-m-d H:i'));
$pdf->setHeaderFont(Array('helvetica', '', 10));
$pdf->setFooterFont(Array('helvetica', '', 8));
$pdf->SetMargins(10, 20, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(TRUE, 15);
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 9);

$html = '<table border="1" cellpadding="4">
<thead style="background:#4f46e5;color:#fff;"><tr style="background:#eee;">
<th>#</th><th>Name</th><th>Phone</th><th>Email</th><th>Status</th><th>Rank</th><th>DOB</th><th>Marital Status</th><th>State</th><th>LGA</th><th>Permanent Address</th><th>EYN LCC</th><th>EYN DCC</th><th>Occupation</th><th>Education</th><th>Skills</th><th>Other Skills</th><th>Registered</th>
</tr></thead><tbody>';
$serial = 1;
foreach ($members as $m) {
    $html .= '<tr>';
    $html .= '<td>'.$serial++.'</td>';
    $html .= '<td>'.htmlspecialchars($m['fullname']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['phone']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['email']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['status']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['rank']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['dob']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['marital_status']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['state_of_origin']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['lga']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['permanent_address']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['eyn_lcc']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['eyn_dcc']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['occupation']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['education']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['skill']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['other_skill']).'</td>';
    $html .= '<td>'.htmlspecialchars($m['created_at']).'</td>';
    $html .= '</tr>';
}
$html .= '</tbody></table>';

$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('members_list.pdf', 'I');
exit;
