<?php
include 'include/layout.php';
require 'db/db.php';

// Fetch user info
$user_id = $_SESSION['user']['user_id']; // Assuming user ID is stored in session
if (!isset($user_id)) {
    header('Location: login.php');
    exit();
}
$sql = "SELECT * FROM tbl_members_info WHERE user_id = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'i', $user_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$user = mysqli_fetch_assoc($result);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Only allow update of allowed fields
    $marital_status = $_POST['marital_status'];
    $state = $_POST['state_of_origin'];
    $lga = $_POST['lga'];
    $eyn_lcc = $_POST['eyn_lcc'];
    $eyn_dcc = $_POST['eyn_dcc'];
    $permanent_address = $_POST['permanent_address'];
    $occupation = $_POST['occupation'];
    $education = $_POST['education'];
    $skill = $_POST['skill'];
    $other_skill = $_POST['other_skill'];

    // Handle profile picture upload
    $profile_picture = $user['profile_picture'];
    if (isset($_FILES['profile_pic']) && $_FILES['profile_pic']['error'] == UPLOAD_ERR_OK) {
        $target_dir = "images/profile_pics/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_name = uniqid() . '_' . basename($_FILES['profile_pic']['name']);
        $target_file = $target_dir . $file_name;
        if (move_uploaded_file($_FILES['profile_pic']['tmp_name'], $target_file)) {
            $profile_picture = $target_file;
        }
    }

    $sql = "UPDATE tbl_members_info SET marital_status=?, state_of_origin=?, lga=?, eyn_lcc=?, eyn_dcc=?, permanent_address=?, occupation=?, education=?, skill=?, other_skill=?, profile_picture=? WHERE user_id=?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'sssssssssssi', $marital_status, $state, $lga, $eyn_lcc, $eyn_dcc, $permanent_address, $occupation, $education, $skill, $other_skill, $profile_picture, $user_id);
    mysqli_stmt_execute($stmt);

    // Show success message
  $_SESSION['profile_updated'] = "1";
    // Redirect to profile page after success
    header('Location: profile.php');
    exit();
}
?>

<div class="container">
  <h2>Update Profile</h2>
  <form method="post" enctype="multipart/form-data">
    <h3>Personal Information</h3>
    <div class="row mb-3">
      <div class="col-md-4 mb-2 mb-md-0">
        <label class="form-label">Marital Status</label>
        <select name="marital_status" class="form-select">
          <option value="Single" <?php if (($user['marital_status'] ?? '') == 'Single') echo 'selected'; ?>>Single</option>
          <option value="Married" <?php if (($user['marital_status'] ?? '') == 'Married') echo 'selected'; ?>>Married</option>
          <option value="Divorced" <?php if (($user['marital_status'] ?? '') == 'Divorced') echo 'selected'; ?>>Divorced</option>
        </select>
      </div>
      <div class="col-md-4 mb-2 mb-md-0">
        <label class="form-label">State of Origin</label>
        <input name="state_of_origin" class="form-control" value="<?php echo htmlspecialchars($user['state_of_origin'] ?? ''); ?>">
      </div>
      <div class="col-md-4 mb-2 mb-md-0">
        <label class="form-label">LGA</label>
        <input name="lga" class="form-control" value="<?php echo htmlspecialchars($user['lga'] ?? ''); ?>">
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Contact Address EYN LCC</label>
        <input name="eyn_lcc" class="form-control" value="<?php echo htmlspecialchars($user['eyn_lcc'] ?? ''); ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">EYN DCC</label>
        <input name="eyn_dcc" class="form-control" value="<?php echo htmlspecialchars($user['eyn_dcc'] ?? ''); ?>">
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-12">
        <label class="form-label">Permanent Home Address</label>
        <textarea name="permanent_address" class="form-control" rows="2"><?php echo htmlspecialchars($user['permanent_address'] ?? ''); ?></textarea>
      </div>
    </div>
    <h3>Occupation / Skills</h3>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Occupation</label>
        <select name="occupation" class="form-select">
          <option <?php if (($user['occupation'] ?? '') == 'Private') echo 'selected'; ?>>Private</option>
          <option <?php if (($user['occupation'] ?? '') == 'Self-employed') echo 'selected'; ?>>Self-employed</option>
          <option <?php if (($user['occupation'] ?? '') == 'Civil Servant') echo 'selected'; ?>>Civil Servant</option>
          <option <?php if (($user['occupation'] ?? '') == 'Applicant') echo 'selected'; ?>>Applicant</option>
          <option <?php if (($user['occupation'] ?? '') == 'Student') echo 'selected'; ?>>Student</option>
          <option <?php if (($user['occupation'] ?? '') == 'Other') echo 'selected'; ?>>Other</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Educational Qualification</label>
        <select name="education" class="form-select">
          <option <?php if (($user['education'] ?? '') == 'SSCE') echo 'selected'; ?>>SSCE</option>
          <option <?php if (($user['education'] ?? '') == 'OND') echo 'selected'; ?>>OND</option>
          <option <?php if (($user['education'] ?? '') == 'HND') echo 'selected'; ?>>HND</option>
          <option <?php if (($user['education'] ?? '') == 'PGD') echo 'selected'; ?>>PGD</option>
          <option <?php if (($user['education'] ?? '') == 'B.Sc') echo 'selected'; ?>>B.Sc</option>
          <option <?php if (($user['education'] ?? '') == 'Masters') echo 'selected'; ?>>Masters</option>
          <option <?php if (($user['education'] ?? '') == 'PhD') echo 'selected'; ?>>PhD</option>
        </select>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Professional Skills (handwork)</label>
        <select name="skill" class="form-select">
          <option <?php if (($user['skill'] ?? '') == 'Tiller') echo 'selected'; ?>>Tiller</option>
          <option <?php if (($user['skill'] ?? '') == 'Mason') echo 'selected'; ?>>Mason</option>
          <option <?php if (($user['skill'] ?? '') == 'Tailor') echo 'selected'; ?>>Tailor</option>
          <option <?php if (($user['skill'] ?? '') == 'Painter') echo 'selected'; ?>>Painter</option>
          <option <?php if (($user['skill'] ?? '') == 'Mechanic') echo 'selected'; ?>>Mechanic</option>
          <option <?php if (($user['skill'] ?? '') == 'Carpenter') echo 'selected'; ?>>Carpenter</option>
          <option <?php if (($user['skill'] ?? '') == 'Electrician') echo 'selected'; ?>>Electrician</option>
          <option <?php if (($user['skill'] ?? '') == 'Other') echo 'selected'; ?>>Other</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Other Professional Skills</label>
        <input name="other_skill" class="form-control" value="<?php echo htmlspecialchars($user['other_skill'] ?? ''); ?>">
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Profile Picture</label>
        <input type="file" name="profile_pic" class="form-control" accept="image/*">
        <?php if (!empty($user['profile_picture'])): ?>
          <img src="<?php echo $user['profile_picture']; ?>" alt="Profile" class="profile-logo mt-2" style="width:80px;height:80px;object-fit:cover;border-radius:50%;">
        <?php endif; ?>
      </div>
    </div>
    <input type="submit" class="btn btn-primary" value="Update Profile" name="update_profile">
  </form>
</div>

<?php include 'include/footer.php'; ?>
