<?php
include 'include/layout.php';
include 'db/db.php';
if (!isset($_SESSION)) {
    session_start();
}

$user_id = $_SESSION['user']['user_id'] ?? null; // Assuming user ID is stored in session
if (!$user_id) {
    header('Location: login.php');
    exit();
} 

// Get member_info_id
$res = $conn->query("SELECT member_info_id FROM tbl_members_info WHERE user_id = $user_id");
$row = $res->fetch_assoc();
if (!$row) { echo '<div class="alert alert-danger">Member not found.</div>'; exit; }
$member_id = $row['member_info_id'];
// Get dues for this member
$dues = $conn->query("SELECT year, status, payment_date FROM tbl_membership_dues WHERE member_info_id = $member_id ORDER BY year DESC");
?>
<div class="container table-responsive">
  <h2>My Membership Dues Status</h2>
  <table class="table table-bordered table-striped member-table">
    <thead><tr><th>#</th><th>Year</th><th>Status</th><th>Payment Date</th></tr></thead>
    <tbody>
      <?php if ($dues->num_rows == 0): ?>
        <tr><td colspan="4">No payment records found. Kindly Wait for Finance Confirmation if you have made a payment.</td></tr>
      <?php else: $serial = 1; while($d = $dues->fetch_assoc()): ?>
        <tr>
          <td><?= $serial++ ?></td>
          <td><?= htmlspecialchars($d['year']) ?></td>
          <td><span class="badge bg-<?= $d['status']==='Paid' ? 'success' : 'danger' ?>"><?= $d['status'] ?></span></td>
          <td><?= $d['payment_date'] ? htmlspecialchars($d['payment_date']) : '-' ?></td>
        </tr>
      <?php endwhile; endif; ?>
    </tbody>
  </table>
</div>
<?php include 'include/footer.php'; ?>
