<?php include 'include/layout.php';  ?>
<div class="container">
  <h2>Dashboard</h2>
  <p>Welcome to your dashboard. Here you can manage your profile, view team statistics, and more.</p>
  <?php
    require 'db/db.php';
    // Get real member counts
    $totalMembers = 0;
    $approvedMembers = 0;
    $pendingMembers = 0;
    $canceledMembers = 0;
    $occupationData = [];

    // Total members
    $result = mysqli_query($conn, "SELECT COUNT(*) as cnt FROM tbl_members_info");
    if ($row = mysqli_fetch_assoc($result)) {
      $totalMembers = $row['cnt'];
    }

    // Approved
    $result = mysqli_query($conn, "SELECT COUNT(*) as cnt FROM tbl_members_info WHERE status='approved'");
    if ($row = mysqli_fetch_assoc($result)) {
      $approvedMembers = $row['cnt'];
    }

    // Pending
    $result = mysqli_query($conn, "SELECT COUNT(*) as cnt FROM tbl_members_info WHERE status='pending'");
    if ($row = mysqli_fetch_assoc($result)) {
      $pendingMembers = $row['cnt'];
    }

    // Canceled
    $result = mysqli_query($conn, "SELECT COUNT(*) as cnt FROM tbl_members_info WHERE status='canceled'");
    if ($row = mysqli_fetch_assoc($result)) {
      $canceledMembers = $row['cnt'];
    }

    // Occupation breakdown
    $result = mysqli_query($conn, "SELECT occupation, COUNT(*) as cnt FROM tbl_members_info GROUP BY occupation");
    while ($row = mysqli_fetch_assoc($result)) {
      $occupationData[$row['occupation']] = $row['cnt'];
    }
  ?>
  
  <main class="content">
    <h4 class="mb-4">Team Overview</h4>
    
    <div class="row mb-4">
      <div class="col-md-6">
        <div class="card shadow-sm">
          <div class="card-body">
            <h6 class="card-title">Members by Status</h6>
            <canvas id="statusPie"></canvas>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card shadow-sm">
          <div class="card-body">
            <h6 class="card-title">Members by Occupation</h6>
            <canvas id="occupationBar"></canvas>
          </div>
        </div>
      </div>
    </div>
    <div class="row mb-4">
      <div class="col-md-3">
        <div class="card text-center shadow-sm">
          <div class="card-body">
            <h6 class="card-title text-muted">All Members</h6>
            <h2 class="card-text text-primary"><?= $totalMembers ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card text-center shadow-sm">
          <div class="card-body">
            <h6 class="card-title text-muted">Approved</h6>
            <h2 class="card-text text-success"><?= $approvedMembers ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card text-center shadow-sm">
          <div class="card-body">
            <h6 class="card-title text-muted">Pending</h6>
            <h2 class="card-text text-warning"><?= $pendingMembers ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card text-center shadow-sm">
          <div class="card-body">
            <h6 class="card-title text-muted">Canceled</h6>
            <h2 class="card-text text-danger"><?= $canceledMembers ?></h2>
          </div>
        </div>
      </div>
    </div>


    <!-- You can add more reports here, e.g. by education, skills, etc. -->
  <div> 
    <h3>Quick Links</h3>
    <div class="list-group mb-4">
      <a href="profile.php" class="list-group-item list-group-item-action"><i class="fa fa-user"></i> View My Profile</a>
      <a href="manage_dues.php" class="list-group-item list-group-item-action"><i class="fa fa-money-bill"></i> Manage Dues</a>
      <a href="manage_members.php" class="list-group-item list-group-item-action"><i class="fa fa-users"></i> Manage Members</a> 
      <a href="manage_publications.php" class="list-group-item list-group-item-action"><i class="fa fa-newspaper"></i> Manage Publications</a>   
  </div>
   
  </main>
</div>
    <!-- Chart.js CDN -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
      // Members by Status Pie
      const statusPie = document.getElementById('statusPie').getContext('2d');
      new Chart(statusPie, {
        type: 'pie',
        data: {
          labels: ['Approved', 'Pending', 'Canceled'],
          datasets: [{
            data: [<?= $approvedMembers ?>, <?= $pendingMembers ?>, <?= $canceledMembers ?>],
            backgroundColor: ['#198754', '#ffc107', '#dc3545'],
          }]
        },
        options: {
          responsive: true,
          plugins: { legend: { position: 'bottom' } }
        }
      });

      // Members by Occupation Bar
      const occupationBar = document.getElementById('occupationBar').getContext('2d');
      new Chart(occupationBar, {
        type: 'bar',
        data: {
          labels: <?= json_encode(array_keys($occupationData)) ?>,
          datasets: [{
            label: 'Members',
            data: <?= json_encode(array_values($occupationData)) ?>,
            backgroundColor: '#0d6efd',
          }]
        },
        options: {
          responsive: true,
          plugins: { legend: { display: false } },
          scales: { y: { beginAtZero: true } }
        }
      });
    </script>
<?php include 'include/footer.php'; ?>
